<?php

    global $ulz_explore;

    $term = null;
    $has_more = null;
    $title = apply_filters('utillz/explore/global/title', esc_html__( 'Explore', 'utillz-core') );

    if( $ulz_explore->type && $ulz_explore->type->id ) {

        $title = $ulz_explore->type->get('ulz_name_plural');

        $fields = Ucore()->json_decode( $ulz_explore->type->get('ulz_fields') );
        foreach( $fields as $field ) {
            if( $field->template->id == 'taxonomy' ) {
                if( ! $ulz_explore->request->is_empty( Ucore()->unprefix( $field->fields->key ) ) ) {

                    $term_value = $ulz_explore->request->get( Ucore()->unprefix( $field->fields->key ) );
                    $term_name = Ucore()->prefix( $field->fields->key );

                    if( is_array( $term_value ) ) {
                        $has_more = true;
                        $term_value = reset( $term_value );
                    }

                    $term = get_term_by( 'slug', $term_value, $term_name );

                    if( $term ) {
                        $title = $term->name;
                    }

                }
            }
        }
    }

?>

<div class="ulz-dynamic" data-dynamic="title">
    <header class="ulz-explore-title">
        <?php if( $title ): ?>
            <h1><?php echo esc_html( $title ); ?></h1>
        <?php endif; ?>
    </header>
</div>
